<?php

namespace App\Http\Requests\Admin\Settlement;

use Illuminate\Foundation\Http\FormRequest;

class Store extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $image = ($this->status == 'refused')?'nullable':'required';
        $amount = ($this->status == 'refused')?'nullable':'required';
        return [
            'id'     => 'required|exists:settlements,id',
            'total_price' => $amount,
            'image'  => [$image,'image','mimes:jpeg,png,jpg,gif,svg'],
            'status' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'amount.required' => __('site.amount_required'),
            'image.required' => __('site.image_required'),
        ];
    }


}
