@extends('admin.layout.master')

@section('content')
    <!-- // Basic multiple Column Form section start -->
    <section id="multiple-column-form">
        <div class="row match-height">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{awtTrans('القيم الإجمالية')}}</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <form class="store form-horizontal">
                                <div class="form-body">
                                    <div class="card-content">
                                        <div class="col-md-6 col-12">
                                            <div class="textCenter">
                                                @if($settlement->image)
                                                    <img class="v-img__img v-img__img--cover"
                                                         src="{{$settlement->ImagePath}}"
                                                         style="width: 500px">
                                                @else
                                                    <p>{{__('admin.No_photo_of_receipt')}}</p>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4 col-8">
                                        <div class="form-group">
                                            <label for="first-name-column">{{awtTrans('إجمالي الطلبات')}}</label>
                                            <div class="controls">
                                                <input type="text"
                                                       value="{{$settlement->total_price??''}}" class="form-control"
                                                       required
                                                       data-validation-required-message="{{__('admin.this_field_is_required')}}" readonly>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-8">
                                        <div class="form-group">
                                            <label for="first-name-column">{{awtTrans('إجمالي القيمه المضافه')}}</label>
                                            <div class="controls">
                                                <input type="text"
                                                       value="{{$settlement->total_app_percentage??''}}"
                                                       name="user_id" class="form-control"
                                                       data-validation-required-message="{{__('admin.this_field_is_required')}}" readonly>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-8 px-5">
                                        <div class="form-group">
                                            <label for="first-name-column">{{awtTrans('إجمالي عموله التطبيق')}}</label>
                                            <div class="controls">
                                                <input type="text"
                                                       value="{{$settlement->total_app_percentage??''}}"
                                                       name="user_id" class="form-control"
                                                       data-validation-required-message="{{__('admin.this_field_is_required')}}" readonly>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-8">
                                        <div class="form-group">
                                            <label for="first-name-column">{{awtTrans('إجمالي القيمه المستحقه ')}}</label>
                                            <div class="controls">
                                                <input type="text"
                                                       value="{{$settlement->total_due??''}}"
                                                       name="user_id" class="form-control"
                                                       data-validation-required-message="{{__('admin.this_field_is_required')}}" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        </form>
        </div>
        <div class="col-md-6 col-lg-6">
            <div class="card">
                <div class="card-header" style="background: #7367f0 ;">
                    <!-- Card header -->
                    <div class="card-title mb-0">{{__('admin.settlement_orders_deatils')}}</div>

                </div>
                <!-- Card body -->
                @foreach($settlementOrder ?? [] as $order)
                    <div class="card-body">
                        <div class="contain-table-n">
                            <table class="w-100 mb-2">

                                <tr>
                                    <td class="font-weight-bold">
                                        {{__('admin.order_number')}}
                                    </td>
                                    <td>
                                        {{$order->order->order_num ?? ''}}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">
                                        {{__('admin.total_order')}}
                                    </td>
                                    <td>{{ $order->order->total_price .' '. __('admin.r_s') }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">
                                        {{__('admin.order_amount')}}
                                    </td>
                                    <td>{{ $order->order->price .' '. __('admin.r_s') }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">
                                        {{__('admin.app_percentage')}}
                                    </td>
                                    <td>{{ $order->order->app_percentage .' '. __('admin.r_s') }}</td>
                                </tr>
                                <tr>
                                    <td class="font-weight-bold">
                                        {{__('admin.vat_amount')}}
                                    </td>
                                    <td>{{ $order->order->added_value .' '. __('admin.r_s') }}</td>
                                </tr>
                                {{--                                <tr>--}}
                                {{--                                    <td class="font-weight-bold">--}}
                                {{--                                        {{__('admin.timing')}}--}}
                                {{--                                    </td>--}}
                                {{--                                    <td>{!! \Carbon\Carbon::parse($order->created_at)->diffForHumans() !!}</td>--}}
                                {{--                                </tr>--}}
                                <tr>
                                    <td class="font-weight-bold">
                                        {{__('admin.order_date')}}
                                    </td>
                                    <td>{{ \Carbon\Carbon::parse($order->created_at)->format('d/m/Y')}}</td>
                                </tr>

                            </table>
                        </div>
                    </div>
                @endforeach
                @if($settlement->status=='refused')
                <div class="card-body">
                    <div class="contain-table-n">
                        <table class="w-100 mb-2">
                        </table>

                        <tr>
                            <td class="font-weight-bold">
                                {{awtTrans('سبب الرفض ')}}
                            </td>
                            <td>{{$settlement->refuse_reason??''}}</td>
                        </tr>

                    </div>
                </div>
                @endif
        </div>
        <div class="card_body">

        </div>
        <div class="col-12 d-flex justify-content-center mt-3">
            <a href="{{ url()->previous() }}" type="reset"
               class="btn btn-outline-warning mr-1 mb-1">{{__('admin.back')}}</a>
        </div>
    </section>

@endsection

@section('js')
    <script>
        $('.show input').attr('disabled', true)
        $('.show textarea').attr('disabled', true)
        $('.show select').attr('disabled', true)
    </script>
@endsection